#ifdef GL_ES 
#define LOWP lowp
#define MED mediump
#define HIGH highp
precision highp float;
#else
#define MED
#define LOWP
#define HIGH
#endif

varying vec4 v_color;  
varying vec2 v_texCoords;  
uniform float u_alpha;
uniform vec2 u_direction;
uniform vec4 u_bounds;

uniform sampler2D u_texture;  


void main(){              
  vec4 col = v_color * texture2D(u_texture, v_texCoords);
  vec2 ratioPos = (gl_FragCoord.xy - u_bounds.xy) / u_bounds.zw;  
  	

	ratioPos = ratioPos * u_direction + max(vec2(0.0,0.0), u_direction*-1.0);

  

  if(ratioPos.x < u_alpha && ratioPos.y < u_alpha) {
    col.a=0.0;
  }
  
  gl_FragColor = col;
}

